/**
 * Toolbar.js
 *
 * @fileoverview  jQuery plugin that creates tooltip style toolbars.
 * @link          http://paulkinzett.github.com/toolbar/
 * @author        Paul Kinzett (http://kinzett.co.nz/)
 * @version       1.1.0
 * @requires      jQuery 1.7+
 *
 * @license jQuery Toolbar Plugin v1.1.0
 * http://paulkinzett.github.com/toolbar/
 * Copyright 2013 - 2015 Paul Kinzett (http://kinzett.co.nz/)
 * Released under the MIT license.
 * <https://raw.github.com/paulkinzett/toolbar/master/LICENSE.txt>
 */
"function"!=typeof Object.create&&(Object.create=function(obj){function F(){}return F.prototype=obj,new F}),define("block_remuiblck/jquery-toolbar",["jquery"],(function($){var ToolBar={init:function(options,elem){this.elem=elem,this.$elem=$(elem),this.options=$.extend({},$.fn.toolbar.options,options),this.metadata=this.$elem.data(),this.overrideOptions(),this.toolbar=$('<div class="tool-container" />').addClass("tool-"+this.options.position).addClass("toolbar-"+this.options.style).append('<div class="tool-items" />').append('<div class="arrow" />').appendTo("body").css("opacity",0).hide(),this.toolbar_arrow=this.toolbar.find(".arrow"),this.initializeToolbar()},overrideOptions:function(){var self=this;$.each(self.options,(function($option){void 0!==self.$elem.data("toolbar-"+$option)&&(self.options[$option]=self.$elem.data("toolbar-"+$option))}))},initializeToolbar:function(){this.populateContent(),this.setTrigger(),this.toolbarWidth=this.toolbar.width()},setTrigger:function(){var self=this;if("click"!=self.options.event){function decideTimeout(){self.$elem.hasClass("pressed")?moveTime=setTimeout((function(){self.hide()}),150):clearTimeout(moveTime)}self.$elem.on({mouseenter:function(event){self.$elem.hasClass("pressed")?clearTimeout(moveTime):self.show()}}),self.$elem.parent().on({mouseleave:function(event){decideTimeout()}}),$(".tool-container").on({mouseenter:function(event){clearTimeout(moveTime)},mouseleave:function(event){decideTimeout()}})}if("click"==self.options.event&&(self.$elem.on("click",(function(event){event.preventDefault(),self.$elem.hasClass("pressed")?self.hide():self.show()})),self.options.hideOnClick&&$("html").on("click.toolbar",(function(event){event.target!=self.elem&&0===self.$elem.has(event.target).length&&0===self.toolbar.has(event.target).length&&self.toolbar.is(":visible")&&self.hide()}))),self.options.hover){var moveTime;function decideTimeout(){self.$elem.hasClass("pressed")?moveTime=setTimeout((function(){self.hide()}),150):clearTimeout(moveTime)}self.$elem.on({mouseenter:function(event){self.$elem.hasClass("pressed")?clearTimeout(moveTime):self.show()}}),self.$elem.parent().on({mouseleave:function(event){decideTimeout()}}),$(".tool-container").on({mouseenter:function(event){clearTimeout(moveTime)},mouseleave:function(event){decideTimeout()}})}$(window).resize((function(event){event.stopPropagation(),self.toolbar.is(":visible")&&(self.toolbarCss=self.getCoordinates(self.options.position,20),self.collisionDetection(),self.toolbar.css(self.toolbarCss),self.toolbar_arrow.css(self.arrowCss))}))},populateContent:function(){var self=this,location=self.toolbar.find(".tool-items"),content=$(self.options.content).clone(!0).find("a").addClass("tool-item");location.html(content),location.find(".tool-item").on("click",(function(event){event.preventDefault(),self.$elem.trigger("toolbarItemClick",this)}))},calculatePosition:function(){this.arrowCss={},this.toolbarCss=this.getCoordinates(this.options.position,this.options.adjustment),this.toolbarCss.position="absolute",this.toolbarCss.zIndex=this.options.zIndex,this.collisionDetection(),this.toolbar.css(this.toolbarCss),this.toolbar_arrow.css(this.arrowCss)},getCoordinates:function(position,adjustment){switch(this.coordinates=this.$elem.offset(),this.options.adjustment&&this.options.adjustment[this.options.position]&&(adjustment=this.options.adjustment[this.options.position]+adjustment),this.options.position){case"top":return{left:this.coordinates.left-this.toolbar.width()/2+this.$elem.outerWidth()/2,top:this.coordinates.top-this.$elem.outerHeight()-adjustment,right:"auto"};case"left":return{left:this.coordinates.left-this.toolbar.width()/2-this.$elem.outerWidth()/2-adjustment,top:this.coordinates.top-this.toolbar.height()/2+this.$elem.outerHeight()/2,right:"auto"};case"right":return{left:this.coordinates.left+this.toolbar.width()/2+this.$elem.outerWidth()/2+adjustment,top:this.coordinates.top-this.toolbar.height()/2+this.$elem.outerHeight()/2,right:"auto"};case"bottom":return{left:this.coordinates.left-this.toolbar.width()/2+this.$elem.outerWidth()/2,top:this.coordinates.top+this.$elem.outerHeight()+adjustment,right:"auto"}}},collisionDetection:function(){"top"!=this.options.position&&"bottom"!=this.options.position||(this.arrowCss={left:"50%",right:"50%"},this.toolbarCss.left<20?(this.toolbarCss.left=20,this.arrowCss.left=this.$elem.offset().left+this.$elem.width()/2-20):$(window).width()-(this.toolbarCss.left+this.toolbarWidth)<20&&(this.toolbarCss.right=20,this.toolbarCss.left="auto",this.arrowCss.left="auto",this.arrowCss.right=$(window).width()-this.$elem.offset().left-this.$elem.width()/2-20-5))},show:function(){this.$elem.addClass("pressed"),this.calculatePosition(),this.toolbar.show().css({opacity:1}).addClass("animate-"+this.options.animation),this.$elem.trigger("toolbarShown")},hide:function(){var self=this,animation={opacity:0};switch(self.$elem.removeClass("pressed"),self.options.position){case"top":animation.top="+=20";break;case"left":animation.left="+=20";break;case"right":animation.left="-=20";break;case"bottom":animation.top="-=20"}self.toolbar.animate(animation,200,(function(){self.toolbar.hide()})),self.$elem.trigger("toolbarHidden")},getToolbarElement:function(){return this.toolbar.find(".tool-items")}};$.fn.toolbar=function(options){if($.isPlainObject(options))return this.each((function(){var toolbarObj=Object.create(ToolBar);toolbarObj.init(options,this),$(this).data("toolbarObj",toolbarObj)}));if("string"==typeof options&&0!==options.indexOf("_")){var toolbarObj=$(this).data("toolbarObj"),method=toolbarObj[options];return method.apply(toolbarObj,$.makeArray(arguments).slice(1))}},$.fn.toolbar.options={content:"#myContent",position:"top",hideOnClick:!1,zIndex:120,hover:!1,style:"default",animation:"standard",adjustment:10}}));

//# sourceMappingURL=jquery-toolbar.min.js.map